// bump.vsh

attribute vec3 Tangent;

uniform mat4 vc4;
uniform vec3 vc2;
uniform vec3 vc12;

#define worldViewProj vc4
#define sunDirection vc2
#define sunPosition vc12

varying vec3 TangentSpaceSunDir;
varying vec3 TangentSpaceHalfVec;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * worldViewProj;
	
	// Set tex coords.  Diffuse and bump map share same coords.
#ifdef CLIFF
    gl_TexCoord[0].st = gl_MultiTexCoord2.st;
#else
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
#endif
	
	// Compute binormal.
	// If tangent is halved in length, that means the binormal is flipped, so we
	// construct a negated binormal and rescale the tangent by 2.0.
	
	float tanLenSqr = dot(Tangent, Tangent);
	vec3 binormal;
	vec3 vTangent = Tangent;
	if( tanLenSqr < 0.3 )
	{
		// Rescale tangent.
		vTangent *= 2.0;
		
		// Flipped binormal.
		binormal = cross(-vTangent, gl_Normal);
	}
	else
	{
		// Standard binormal.
		binormal = -cross(-vTangent, gl_Normal);
	}
	vTangent = -vTangent;
	
	// Move sun direction into tangent space.
	TangentSpaceSunDir.x = dot(vTangent, sunDirection);
	TangentSpaceSunDir.y = dot(binormal, sunDirection);
	TangentSpaceSunDir.z = dot(gl_Normal, sunDirection);

	// Compute H vector.
	vec3 modelSpaceDirToCamera = normalize(sunPosition - gl_Position.xyz);
	vec3 halfAngleVector = normalize(sunDirection + modelSpaceDirToCamera);

	// Move H vector into tangent space.
	vec3 tangentSpaceH;
	tangentSpaceH.x = dot(vTangent, halfAngleVector);
	tangentSpaceH.y = dot(binormal, halfAngleVector);
	tangentSpaceH.z = dot(gl_Normal, halfAngleVector);
   
	TangentSpaceHalfVec = normalize(tangentSpaceH);
}
